//================================================================================
// sr71.
//================================================================================

class MSSR71 extends MSFlyables;

#exec MESH IMPORT MESH=sr71 ANIVFILE=C:\DeusEx\MSDriving1_2\Models\sr71_a.3d DATAFILE=C:\DeusEx\MSDriving1_2\Models\sr71_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=sr71 X=0 Y=0 Z=0 PITCH=0 ROLL=0 YAW=-64
//#exec MESH ORIGIN MESH=sr71 X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=sr71 SEQ=All    STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=sr71 SEQ=sr71 STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=sr71 FILE=C:\DeusEx\MSDriving1_2\Textures\sr71.PCX GROUP=Skins

#exec MESHMAP NEW   MESHMAP=sr71 MESH=sr71
#exec MESHMAP SCALE MESHMAP=sr71 X=2.5 Y=2.5 Z=2.5
//#exec MESHMAP SCALE MESHMAP=sr71 X=0.024765625 Y=0.024765625 Z=0.024765625

#exec MESHMAP SETTEXTURE MESHMAP=sr71 NUM=0 TEXTURE=sr71

function Frob(Actor Frobber, Inventory frobWith)
{
}

event HitWall( vector HitNormal, actor HitWall )
{
 SetPhysics(PHYS_Falling);
 
 Super.HitWall(HitNormal, HitWall);
}

state MSDriving1
{

function Tick(float DeltaTime)
{
  local Actor Other;
  local int X, Y;
//  local vector PassengerDump;
//  local rotator WORKDAMMIT;

 if (LastGasTimer <= 0)
 {
  if (Physics != PHYS_Falling)
   SetPhysics(PHYS_Falling);
 }

//  if (MSCarDriver != None)
//  {
//    SetLocation(MSCarDriver.Location + vect(0,0,1) * CollisionHeight / 2);
//a little calculation to measure how fast the car is going, used for damage calculation.
//    MSCarSpeed = (MSCarDriver.Location.X - MSCarDriver.OldLocation.X) + (MSCarDriver.Location.Y - MSCarDriver.OldLocation.Y);
if (Level.NetMode == NM_Standalone)
{
 if ((LeftGun.IsA('DrivableWeaponRPG')) && (LeftGunPos != LRPGPos))
 {
   LeftGunPos = LRPGPos;
   RightGunPos = RRPGPos;
 }
 if ((!LeftGun.IsA('DrivableWeaponRPG')) && (LeftGunPos == LRPGPos))
 {
   LeftGunPos = Default.LeftGunPos;
   RightGunPos = Default.RightGunPos;
 }

    if ((Region.Zone.IsA('RefuelingZone')) && (GasLeft < TopGas * 100000))
     GasLeft += DeltaTime * TopGas * 10000;
}
    /*if (Region.Zone.bWaterZone)
    {
     HandleWaterDriving();
    }*/

    MSCarSpeed = VSize(Velocity) / 21.5;
    if (MSCarSpeed < 1) MSCarSpeed = 0;

    if ((bUseGas) && (GasLeft > 0))//if we are using gas
    {                        //subtract time from our gas
       GasLeft -= DeltaTime * 7.5757575; //jets are constantly using gas, so i give them a maxmimum of 5 1/2 minutes
    }

    if ((bUseGas) && (GasLeft <= 0) && (!bCrashed))
    {
     bCrashed = True;
//     SetPhysics(PHYS_Falling); //its a no brainer that aircraft fall when they're out of gas
//     AmbientSound = None; //dont play a motor sound if the motor isnt running
//     bInvincible = False;
//     LoopAnim('Still');
    }

    if ((Region.Zone.IsA('RefuelingZone')) && (GasLeft < TopGas * 100000))
     GasLeft += DeltaTime * TopGas * 10000;

    if (LastGasTimer > 0) //if the gas timer isnt too low, decrease it
    {
          LastGasTimer -= DeltaTime;
          bStillDriving = True;
    }
  
    if (StallTimer > 0) //if the stall timer isnt too low, decrease it
    {
          StallTimer -= DeltaTime;
    }

    	if (BombTimer > 0)
	BombTimer -= DeltaTime;

    	if (ShotTimer > 0)
	ShotTimer -= DeltaTime;

      HandleDyingDriver();
    
     // HandlePassenger();

      HandleLivingDriver();

     //CheckForRoadKill(Other);

    if ((MSCarDriver != None) && (_flyingscreen != None))
     _flyingscreen.SetMessageText(GetDrivingStats());
//  }  
// Super.Tick(DeltaTime);
}

	function TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
	{
		local float avg;

		if (bStatic || bInvincible)
			return;

		if ((DamageType == 'TearGas') || (DamageType == 'PoisonGas') || (DamageType == 'Radiation'))
			return;

		if ((DamageType == 'EMP') || (DamageType == 'NanoVirus') || (DamageType == 'Shocked'))
			return;

		if (DamageType == 'HalonGas')
			ExtinguishFire();

		if ((DamageType == 'Burned') || (DamageType == 'Flamed'))
		{
			if (bExplosive)		// blow up if we are hit by fire
				HitPoints = 0;
			else if (bFlammable && !Region.Zone.bWaterZone)
			{
				GotoState('Burning');
				return;
			}
		}

		if (Damage >= minDamageThreshold)
			HitPoints -= Damage;
		else
		{
			// sabot damage at 50%
			// explosion damage at 25%
			if (damageType == 'Sabot')
				HitPoints -= Damage * 0.5;
			else if (damageType == 'Exploded')
				HitPoints -= Damage * 0.25;
		}

		if (HitPoints > 0)		// darken it to show damage (from 1.0 to 0.1 - don't go completely black)
		{
			ResetScaleGlow();
		}
		else	// destroy it!
		{
			DropThings();

			// clear the event to keep Destroyed() from triggering the event
			Event = '';
			avg = (CollisionRadius + CollisionHeight) / 2;
			Instigator = EventInstigator;
			if (Instigator != None)
				MakeNoise(1.0);

			if (fragType == class'WoodFragment')
			{
				if (avg > 20)
					PlaySound(sound'WoodBreakLarge', SLOT_Misc,,, 512);
				else
					PlaySound(sound'WoodBreakSmall', SLOT_Misc,,, 512);
				AISendEvent('LoudNoise', EAITYPE_Audio, , 512);
			}

			// if we have been blown up, then destroy our contents
			// CNN - don't destroy contents now
//			if (DamageType == 'Exploded')
//			{
//				Contents = None;
//				Content2 = None;
//				Content3 = None;
//			}

			if (bExplosive)
			{
				Frag(fragType, Momentum * explosionRadius / 4, avg/35.0, avg/10 + 1);
				Explode(HitLocation);
			}
			else
				Frag(fragType, Momentum / 10, avg/20.0, avg/5 + 1);
		}
          	if (Damage >= 1)
		{
                        if (DamageSpots[DamageSpotCount] != None)
                         DamageSpots[DamageSpotCount].DelayedDestroy();

		    	DamageSpots[DamageSpotCount] = Spawn(class'ParticleGenerator', Self,, HitLocation);
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType == 'Sabot'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = 0.123;
				DamageSpots[DamageSpotCount].checkTime = 0.025;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType == 'Exploded'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = Damage / 50;
				DamageSpots[DamageSpotCount].checkTime = 0.025;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType != 'Sabot') && (DamageType != 'Exploded'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = 0.09;
				DamageSpots[DamageSpotCount].checkTime = 0.035;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
                	if ((Damage >= 25) || (HitPoints < Default.HitPoints / 2))
			{
				Frag(fragType, Momentum / 10, avg/30.0, avg/5 + 1);
			}
		}
	}
}

simulated function BlowTheLoad()
{
  local DeusExProjectile proj1, proj2;

   if ((Location.Z > GarageLocation.Z) && (BombsLeft > 0) && (HasBombs))
   {
    proj1 = DeusExProjectile(Spawn(BombType, MSCarDriver,, Location - (vect(0,0,1) * (CollisionHeight + 34)) + vect(0,52.8,0), Rotation + BombRotation));
    proj2 = DeusExProjectile(Spawn(BombType, MSCarDriver,, Location - (vect(0,0,1) * (CollisionHeight + 34)) - vect(0,52.8,0), Rotation + BombRotation));
    BombsLeft -= 2;
   }
}


simulated function MSDriveForward()
{
        local vector vel;
        local float size;
	local Actor           hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
        local vector NormalHeading, NormalDesiredHeading;
        local float HeadingDiffDot;

	position    = Location;
	position.Z += MSCarDriver.BaseEyeHeight;
	line        = Vector(MSCarDriver.ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position + line, position, true);
          
         if (Level.Netmode != NM_Standalone)
         {
            NormalHeading = Normal(Vector(Rotation));
            NormalDesiredHeading = Normal(hitLocation - Location);
            HeadingDiffDot = NormalHeading Dot NormalDesiredHeading;
         }

         if (GasLeft > 0)
         {
         Push += vect(1,1,0) * CarSpeed * 100;
          if (Physics != PHYS_Projectile)
           SetPhysics(PHYS_Projectile);

          if ((Velocity.X + Velocity.Y > Push.X + Push.Y * -1) && (Velocity.X + Velocity.Y <= 0)) //if we aren't breaking our top speed
          {
           CurrentDrivableSpeed = Velocity; //get current speed
           CurrentDrivableSpeed += vect(-1,0,0) * ((MSAccelerationSpeed - (2.5 / CarSpeed))* 6.5); // add its old speed plus some more
	   Velocity -= Velocity; // set speed to zero for a split second
	   Velocity -= CurrentDrivableSpeed; // add the old speed plus a little extra
          }
          if ((Velocity.X + Velocity.Y < Push.X + Push.Y) && (Velocity.X + Velocity.Y >= 0)) //if we aren't breaking our top speed
          {
           CurrentDrivableSpeed = Velocity; //get current speed
           CurrentDrivableSpeed += vect(1,0,0) * ((MSAccelerationSpeed - (2.5 / CarSpeed))* 6.5); // add its old speed plus some more
	   Velocity -= Velocity; // set speed to zero for a split second
	   Velocity -= CurrentDrivableSpeed; // add the old speed plus a little extra
          }
          if (Velocity.X + Velocity.Y > Push.X + Push.Y) //if we ARE breaking out top speed, slow us down
          {
           CurrentDrivableSpeed = Velocity; //get current speed
           CurrentDrivableSpeed -= CurrentDrivableSpeed; //set that speed to zero
           CurrentDrivableSpeed += vect(1,0,0) * CarSpeed * 100; //set speed to top speed
	   Velocity -= Velocity; // set speed to zero for a split second
	   Velocity -= CurrentDrivableSpeed; // and finally set it to top speed
          }
          if (Velocity.X + Velocity.Y < Push.X + Push.Y * -1) //if we ARE breaking out top speed, slow us down
          {
           CurrentDrivableSpeed = Velocity; //get current speed
           CurrentDrivableSpeed -= CurrentDrivableSpeed; //set that speed to zero
           CurrentDrivableSpeed -= vect(1,0,0) * CarSpeed * 100; //set speed to top speed
	   Velocity -= Velocity; // set speed to zero for a split second
	   Velocity -= CurrentDrivableSpeed; // and finally set it to top speed
          }
         size = VSize(Velocity); //arg velocity hack copied from deusexprojectile.uc
         vel = Normal(Vector(Rotation));
         if (Level.NetMode != NM_Standalone)
         {
            size = FMax(HeadingDiffDot,0.4) * (Velocity.X + Velocity.Y);
         }
         Velocity = vel * size;
         LastGasTimer = 3.5; //notify the car that we're still on the gas
         }
}

simulated function MSDriveBackward()
{
        local vector vel;
        local float size;
	local Actor           hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
        local vector NormalHeading, NormalDesiredHeading;
        local float HeadingDiffDot;

	position    = Location;
	position.Z += MSCarDriver.BaseEyeHeight;
	line        = Vector(MSCarDriver.ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position + line, position, true);
          
         if (Level.Netmode != NM_Standalone)
         {
            NormalHeading = Normal(Vector(Rotation));
            NormalDesiredHeading = Normal(hitLocation - Location);
            HeadingDiffDot = NormalHeading Dot NormalDesiredHeading;
         }

         if (GasLeft > 0)
         {
         Push += vect(1,1,0) * CarSpeed * 15;
          if (Physics != PHYS_Projectile)
           SetPhysics(PHYS_Projectile);

          if ((Velocity.X + Velocity.Y < Push.X + Push.Y * -1) && (Velocity.X + Velocity.Y <= 0)) //if we aren't breaking our top speed
          {
           CurrentDrivableSpeed = Velocity; //get current speed
           CurrentDrivableSpeed -= vect(-1,0,0) * ((MSAccelerationSpeed - (2.5 / CarSpeed))* 6.5); // add its old speed plus some more
	   Velocity -= Velocity; // set speed to zero for a split second
	   Velocity -= CurrentDrivableSpeed; // add the old speed plus a little extra
          }
          if ((Velocity.X + Velocity.Y > Push.X + Push.Y) && (Velocity.X + Velocity.Y >= 0)) //if we aren't breaking our top speed
          {
           CurrentDrivableSpeed = Velocity; //get current speed
           CurrentDrivableSpeed -= vect(1,0,0) * ((MSAccelerationSpeed - (2.5 / CarSpeed))* 6.5); // add its old speed plus some more
	   Velocity -= Velocity; // set speed to zero for a split second
	   Velocity -= CurrentDrivableSpeed; // add the old speed plus a little extra
          }
          if (Velocity.X + Velocity.Y > Push.X + Push.Y) //if we ARE breaking out top speed, slow us down
          {
           CurrentDrivableSpeed = Velocity; //get current speed
           CurrentDrivableSpeed -= CurrentDrivableSpeed; //set that speed to zero
           CurrentDrivableSpeed += vect(1,0,0) * CarSpeed * 15; //set speed to top speed
	   Velocity -= Velocity; // set speed to zero for a split second
	   Velocity -= CurrentDrivableSpeed; // and finally set it to top speed
          }
          if (Velocity.X + Velocity.Y < Push.X + Push.Y * -1) //if we ARE breaking out top speed, slow us down
          {
           CurrentDrivableSpeed = Velocity; //get current speed
           CurrentDrivableSpeed -= CurrentDrivableSpeed; //set that speed to zero
           CurrentDrivableSpeed -= vect(1,0,0) * CarSpeed * 15; //set speed to top speed
	   Velocity -= Velocity; // set speed to zero for a split second
	   Velocity -= CurrentDrivableSpeed; // and finally set it to top speed
          }
         size = VSize(Velocity); //arg velocity hack copied from deusexprojectile.uc
         vel = Normal(Vector(Rotation));
         if (Level.NetMode != NM_Standalone)
         {
            size = FMax(HeadingDiffDot,0.4) * (Velocity.X + Velocity.Y);
         }
         Velocity = vel * size;
//         LastGasTimer = 3.5; //notify the car that we're still on the gas
         }
}

simulated function MSFlyUpward()
{
 	local vector vel;
 	local float size;
	local Actor           hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
        local vector NormalHeading, NormalDesiredHeading;
        local float HeadingDiffDot;
        local float VelX, VelY;

         if (GasLeft > 0)
         {
          CarRotation = Rotation; //get current rotation
//          CarRotation.Yaw += BrakeStrength * 200; //add the turn rate (add goes to the right)
          CarRotation.Pitch += BrakeStrength * 200; //minus the turn rate (minus goes to the left)
          SetRotation(CarRotation); //and turn the car to this rotation
         size = VSize(Velocity); //arg velocity hack copied from deusexprojectile.uc
         vel = Normal(Vector(Rotation));

	position    = Location;
	position.Z += MSCarDriver.BaseEyeHeight;
	line        = Vector(MSCarDriver.ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position + line, position, true);

         if (EBrakeTimer <= 0)
          Velocity = vel * size;

         if (Level.Netmode != NM_Standalone)
         {
            NormalHeading = Normal(Vector(Rotation));
            NormalDesiredHeading = Normal(hitLocation - Location);
            HeadingDiffDot = NormalHeading Dot NormalDesiredHeading;
         }
//         if (Level.NetMode != NM_Standalone) //this fucks things up in mp
//         {
//            size = FMax(HeadingDiffDot,0.4) * (Velocity.X + Velocity.Y);
//         }
         LastGasTimer = 3.5; //notify the car that we're still on the gas
         }
}

simulated function MSFlyDownward()
{
 	local vector vel;
 	local float size;
	local Actor           hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
        local vector NormalHeading, NormalDesiredHeading;
        local float HeadingDiffDot;
        local float VelX, VelY;

         if (GasLeft > 0)
         {
          CarRotation = Rotation; //get current rotation
//          CarRotation.Yaw += BrakeStrength * 200; //add the turn rate (add goes to the right)
          CarRotation.Pitch -= BrakeStrength * 200; //minus the turn rate (minus goes to the left)
          SetRotation(CarRotation); //and turn the car to this rotation
         size = VSize(Velocity); //arg velocity hack copied from deusexprojectile.uc
         vel = Normal(Vector(Rotation));

	position    = Location;
	position.Z += MSCarDriver.BaseEyeHeight;
	line        = Vector(MSCarDriver.ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position + line, position, true);

         if (EBrakeTimer <= 0)
          Velocity = vel * size;

         if (Level.Netmode != NM_Standalone)
         {
            NormalHeading = Normal(Vector(Rotation));
            NormalDesiredHeading = Normal(hitLocation - Location);
            HeadingDiffDot = NormalHeading Dot NormalDesiredHeading;
         }
//         if (Level.NetMode != NM_Standalone) //this fucks things up in mp
//         {
//            size = FMax(HeadingDiffDot,0.4) * (Velocity.X + Velocity.Y);
//         }
         LastGasTimer = 3.5; //notify the car that we're still on the gas
         }
}

simulated function MSTurnLeft()
{
        local vector vel;
        local float size;
	local Actor           hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
        local vector NormalHeading, NormalDesiredHeading;
        local float HeadingDiffDot;

         if (GasLeft > 0)
         {
          CarRotation = Rotation; //get current rotation
          CarRotation.Yaw -= BrakeStrength * 200; //minus the turn rate (minus goes to the left)
          SetRotation(CarRotation); //and turn the car to this rotation
         size = VSize(Velocity); //arg velocity hack copied from deusexprojectile.uc
         vel = Normal(Vector(Rotation));
	position    = Location;
	position.Z += MSCarDriver.BaseEyeHeight;
	line        = Vector(MSCarDriver.ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position + line, position, true);

         if (EBrakeTimer <= 0)
          Velocity = vel * size * -1;

         if (Level.Netmode != NM_Standalone)
         {
            NormalHeading = Normal(Vector(Rotation));
            NormalDesiredHeading = Normal(hitLocation - Location);
            HeadingDiffDot = NormalHeading Dot NormalDesiredHeading;
         }
//         if (Level.NetMode != NM_Standalone) //this fucks things up in mp
//         {
//            size = FMax(HeadingDiffDot,0.4) * (Velocity.X + Velocity.Y);
//         }
         if (EBrakeTimer <= 0)
          Velocity = vel * size;
         LastGasTimer = 2.750000; //notify the car that we're still on the gas
         }
}

simulated function MSTurnRight()
{
 	local vector vel;
 	local float size;
	local Actor           hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
        local vector NormalHeading, NormalDesiredHeading;
        local float HeadingDiffDot;
        local float VelX, VelY;

         if (GasLeft > 0)
         {
          CarRotation = Rotation; //get current rotation
          CarRotation.Yaw += BrakeStrength * 200; //add the turn rate (add goes to the right)
          SetRotation(CarRotation); //and turn the car to this rotation
         size = VSize(Velocity); //arg velocity hack copied from deusexprojectile.uc
         vel = Normal(Vector(Rotation));

	position    = Location;
	position.Z += MSCarDriver.BaseEyeHeight;
	line        = Vector(MSCarDriver.ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position + line, position, true);

         if (EBrakeTimer <= 0)
          Velocity = vel * size;

         if (Level.Netmode != NM_Standalone)
         {
            NormalHeading = Normal(Vector(Rotation));
            NormalDesiredHeading = Normal(hitLocation - Location);
            HeadingDiffDot = NormalHeading Dot NormalDesiredHeading;
         }
//         if (Level.NetMode != NM_Standalone) //this fucks things up in mp
//         {
//            size = FMax(HeadingDiffDot,0.4) * (Velocity.X + Velocity.Y);
//         }
         LastGasTimer = 2.750000; //notify the car that we're still on the gas
         }
}

defaultproperties
{
     ItemName="SR-71 Fighter Plane"
     Mesh=LodMesh'MSDriving1_2f.sr71'
     CollisionRadius=225
     CollisionHeight=50
     Mass=6000.00
     Buoyancy=1000.00
     CarSpeed=10
     BrakeStrength=7
     MSAccelerationSpeed=3
     TopGas=10
     LeftGunPos=(X=42.25,Y=35.25,Z=25)
     RightGunPos=(X=42.25,Y=-35.25,Z=25)
     LRPGPos=(X=59.25,Y=35.25,Z=25)
     RRPGPos=(X=59.25,Y=-35.25,Z=25)
     DriverPos=(X=0,Y=-18,Z=0)
     PassengerPos=(X=0,Y=18,Z=0)
     FiringOffsetR=(X=82.5,Y=0,Z=0)
     FiringOffsetL=(X=82.5,Y=0,Z=0)
     bOwnerNoSee=True
     DriverDump=(X=0,Y=144,Z=0)
     PassengerDump=(X=0,Y=-144,Z=0)
     LeftGunRot=(Pitch=-3748,Yaw=0,Roll=0)
     RightGunRot=(Pitch=-3748,Yaw=0,Roll=0)
     DefaultGun=Class'MSDriving1_2f.DrivableWeaponAssaultGun'
     HitPoints=1000
     MaxBombs=40
     BombTime=0.135000
     BombType=Class'MSDriving1_2f.FighterRocket'
     BombRotation=(Pitch=0,Yaw=0,Roll=0)
}